/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.model;

import java.util.Iterator;
import java.util.Vector;
import replicatorg.model.GCodeSource;

public class GCodeSourceCollection
implements GCodeSource {
    final Vector<GCodeSource> sources;
    final int lineCount;

    public GCodeSourceCollection(Vector<GCodeSource> sources) {
        this.sources = sources;
        int lineCount = 0;
        for (GCodeSource source : this.sources) {
            lineCount += source.getLineCount();
        }
        this.lineCount = lineCount;
    }

    @Override
    public Iterator<String> iterator() {
        return new GCodeSourceCollectionIterator(this.sources);
    }

    @Override
    public int getLineCount() {
        return this.lineCount;
    }

    public class GCodeSourceCollectionIterator
    implements Iterator<String> {
        Vector<Iterator<String>> iterators = new Vector();

        public GCodeSourceCollectionIterator(Vector<GCodeSource> sources) {
            for (GCodeSource source : sources) {
                this.iterators.add(source.iterator());
            }
        }

        @Override
        public boolean hasNext() {
            return !this.iterators.isEmpty();
        }

        @Override
        public String next() {
            String next = null;
            if (this.hasNext()) {
                next = this.iterators.firstElement().next();
                if (!this.iterators.firstElement().hasNext()) {
                    this.iterators.remove(0);
                }
            }
            return next;
        }

        @Override
        public void remove() {
        }
    }
}

